//
//  yasee_ios_demoApp.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/8/2.
//

import SwiftUI
import yasee_ios

@main
struct yasee_ios_demoApp: App {
    
    @Environment(\.scenePhase) 
    private var scenePhase
    @State
    var isCloseBl: Bool = false
    
    var body: some Scene {
        WindowGroup {
            NavigationView {
                ContentView()
            }
            .environmentObject(Devices.single)
            .onAppear {
                // 初始化 Yasee
                let _ = Yasee.single
                
                // 设置初始绑定列表
                guard let lds = UserDefaults.standard.data(forKey: "local_devices") else { return }
                do {
                    let jdds = try JSONDecoder().decode([BleDevice].self, from: lds)
                    Yasee.single.initDevices(jdds)
                } catch let err {
                    print("Yasee-SDK: 错误: \(err.localizedDescription)")
                }
                // 设置 蓝牙状态
                let bleStateCall: NotifyCall<NotifyBleState> = { data in
                    let value = data.data
                    isCloseBl = value == .off;
                }
                Notify.single.listen(bleStateCall)
            }
            .onChange(of: scenePhase) { newPhase in
                switch newPhase {
                case .active:
                    print("App is active")
                case .inactive:
                    print("App is inactive")
                case .background:
                    print("存储设备信息")
                    do {
                        let data = try JSONEncoder().encode(Devices.single.allBinds)
                        if data.count <= 2 { return }
                        
                        UserDefaults.standard.setValue(data, forKey: "local_devices")
                        
                    } catch let err {
                        print("Yasee-SDK: 错误: \(err.localizedDescription)")
                    }
                @unknown default:
                    print("Unexpected new value.")
                }
            }
            .alert(Text("蓝牙是否已经开启?"), isPresented: $isCloseBl, actions: {
            }, message: {
                Text("请确认是否已经开启了蓝牙功能")
            })
        }
    }
}
