//
//  Ecg.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/9/13.
//

import SwiftUI
import yasee_ios


struct Ecg: View {
    
    // 模拟心电图数据
    @StateObject
    private var ecgNotify = EcgNotify()
    

    var body: some View {
        GeometryReader { geometry in
            ZStack(alignment: .bottomLeading) {
                
                GeometryReader { geometry in
                    let width = geometry.size.width
                    let height = geometry.size.height
                    
                    let step = width / CGFloat(ecgNotify.ecgData.count)
                    let middleY = height / 2
                    
                    // 使用 Canvas 绘制网格和心电图
                    Canvas { context, size in
                        // 绘制网格
                        drawGrid(context: context, size: size)
                        
                        // 绘制心电图
                        var path = Path()
                        path.move(to: CGPoint(x: 0, y: middleY))
                        
                        for index in 0..<ecgNotify.ecgData.count {
                            
                            var v = ecgNotify.ecgData[index];
                            if v > middleY {
                                v = middleY
                            } else if v < -middleY {
                                v = -middleY
                            }
                            
                            path.addLine(to: .init(x: CGFloat(index) * step,y: middleY + v))
                        }
                        
                        context.stroke(path, with: .color(.green), lineWidth: 2)
                    }
                    .background(Color.black)
                }
                
                // 增益信息
                Text("增益: 10 mm/mv")
                    .foregroundStyle(.white)
            }
        }
        .background(Color.black)
        
    }
    
     
    // 绘制网格线的方法
    private func drawGrid(context: GraphicsContext, size: CGSize) {
        let gridSpacing: CGFloat = 20  // 每个小格子的大小
        let majorLineWidth: CGFloat = 1.5  // 粗线宽度
        let minorLineWidth: CGFloat = 0.5  // 细线宽度
        
        // 绘制竖向网格线
        for x in stride(from: 0, to: size.width, by: gridSpacing) {
            let isMajorLine = Int(x / gridSpacing) % 5 == 0
            let lineWidth = isMajorLine ? majorLineWidth : minorLineWidth
            let lineColor = isMajorLine ? Color.gray : Color.gray.opacity(0.5)
            
            var verticalPath = Path()
            verticalPath.move(to: CGPoint(x: x, y: 0))
            verticalPath.addLine(to: CGPoint(x: x, y: size.height))
            context.stroke(verticalPath, with: .color(lineColor), lineWidth: lineWidth)
        }
        
        // 绘制横向网格线
        for y in stride(from: 0, to: size.height, by: gridSpacing) {
            let isMajorLine = Int(y / gridSpacing) % 5 == 0
            let lineWidth = isMajorLine ? majorLineWidth : minorLineWidth
            let lineColor = isMajorLine ? Color.gray : Color.gray.opacity(0.5)
            
            var horizontalPath = Path()
            horizontalPath.move(to: CGPoint(x: 0, y: y))
            horizontalPath.addLine(to: CGPoint(x: size.width, y: y))
            context.stroke(horizontalPath, with: .color(lineColor), lineWidth: lineWidth)
        }
    }
}

#Preview {
    Ecg()
}
