//
//  DeviceWidget.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/8/5.
//

import SwiftUI
import yasee_ios

struct DeviceWidget: View {
    
    @ObservedObject
    var device: BleDevice
    
    var isBind = false
    
    
    var body: some View {
        HStack {
            HStack {
                ZStack {
                    Circle()
                        .foregroundColor(.random)
                    Text("\(device.name.first!)")
                        .bold()
                        .foregroundStyle(.background)
                        .font(.title)
                }
                VStack(alignment: .leading, content: {
                    Text(device.name)
                        .bold()
                        .foregroundStyle(.orange)
                        .font(Font.system(size: 18))
                    Spacer()
                    Text("MAC: \(device.hMac)")
                        .font(Font.system(size: 12))
                        .foregroundStyle(.gray)
                })
            }
            Spacer()
            Button(action: {
                device.connect()
            }, label: {
                VStack {
                    device.precess != .connected ? Text(isBind ? "绑定" : "连接") : Text("已连接")
                    (device.precess != .connected ? Text("未连接") : Text("T:\(device.endTime - device.startTime)"))
                        .foregroundStyle(.gray)
                }
                
            }).clipShape(.rect(cornerRadius: 6))
                .disabled(device.precess == .connected)
        }.frame(height: 45)
    }
}

#Preview {
    DeviceWidget(device: BleDevice())
}
