//
//  SearchPage.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/8/5.
//

import SwiftUI
import yasee_ios

struct SearchPage: View {
    
    @EnvironmentObject
    var dds: Devices
    
    
    var body: some View {
        List(dds.allSearchs) { device in
            DeviceWidget(device: device)
        }
        .navigationTitle("搜索列表(\(dds.allSearchs.count))")
        .navigationBarItems(trailing: Button(action: {
            Yasee.single.scan()
        }, label: {
            Text("再次")
        }))
        .onAppear(perform: {
            Yasee.single.scan()
        })
    }
}

#Preview {
    NavigationView {
        SearchPage()
    }
}
