//
//  DevicePage.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/8/6.
//

import SwiftUI
import yasee_ios

struct DevicePage: View {
    
    @ObservedObject
    var device: BleDevice
    
    
    @State
    var log : String = "日志信息:\n"
    
    
    var body: some View {
        GeometryReader { geometry in
            VStack(alignment: .trailing) {
                if device.name.starts(with: "T") {
                    Ecg()
                        .frame(height: geometry.size.height * 0.25)
                }
                ScrollViewReader { proxy in
                    ScrollView {
                        Text(log)
                            .id("text")
                            .frame(maxWidth: .infinity)
                    }
                    .onChange(of: log) { _ in
                        withAnimation {
                            proxy.scrollTo("text",anchor: .bottom)
                        }
                    }
                }.frame(height: geometry.size.height * 0.45)
                Spacer()
                LazyVGrid(columns: [
                    GridItem(),GridItem(),
                    GridItem(),GridItem(),
                ]) {
                    ForEach(device.supportChecks,id: \.id) { check in
                        Text(check.name)
                            .padding()
                            .foregroundColor(.orange)
                            .shadow(radius: 10)
                            .clipShape(.rect(cornerRadius: 5))
                            .contextMenu(ContextMenu(menuItems: {
                                ForEach(check.cmds, id: \.id) { cmd in
                                    Button {
                                        do {
//                                            let dataTime = 24 * 60 * 60;
                                            let dataTime = 60;
                                            try device.send(check.handwareCode, cmd.id.uuidString, [ "time": dataTime, "startTime": Int(Date().timeIntervalSince1970) - dataTime * 1000 ])
                                        } catch let err {
                                            log = ("""
============================================\n
错误信息:\(err.localizedDescription)
""")
                                        }
                                    } label: {
                                        Text(cmd.desc)
                                    }

                                }
                            }))
                    }
                }.frame(height: geometry.size.height * 0.30)
            }
        }
        .navigationTitle(device.name)
        .navigationBarItems(trailing: Button(action: {}, label: {
            Button(action: {
                if device.precess != .connected {
                    return
                }
                
            }, label: {
                Text(device.precess == .connected ? "已连接" : "未连接")
            })
            
        }))
        .onAppear {
            
            do {
                try device.send([0xAA,0x55,0x04,0x81,0xFF])
            } catch let err {
                log = ("""
============================================\n
交互状态: \(false)\n
设备信息: \(device.name)(\(device.hMac))\n
数据详情: \(err.localizedDescription)\n
""")
            }
            
            
            let stringCall: NotifyCall<NotifyDeviceData> = { data in
                let value = data.data.data
                do {
                    // 将 JSON 数据转换为字符串
                    if let jsonString = String(data: value, encoding: .utf8) {
                        log = ("""
============================================\n
交互状态: \(data.success)\n
设备信息: \(data.data.device.name)(\(data.data.device.hMac))\n
数据详情: \(jsonString)\n
""")
                    }
                } catch {
                    print("Failed to encode dictionary: \(error)")
                }
                
            }
            Notify.single.listen(stringCall)
            
        }
    }
    
    
    
    
}

#Preview {
    DevicePage(device: BleDevice())
}
