//
//  ContentView.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/8/2.
//

import SwiftUI
import yasee_ios
import Combine


struct ContentView: View {
    
    
    @EnvironmentObject
    var dds: Devices
    
    
    var body: some View {
        
        List {
            ForEach(dds.allBinds.indices, id: \.self) { index in
                NavigationLink {
                    DevicePage(device: dds.allBinds[index] )
                } label: {
                    DeviceWidget(device: dds.allBinds[index], isBind: true)
                }
            }
            .onDelete { offsets in
                let dds = offsets.map { self.dds.allBinds[$0] }
                Yasee.single.unBinds(dds)
            }
        }
        .navigationTitle("已绑定设备")
        .navigationBarItems(trailing: NavigationLink(destination: SearchPage()) {
            Text("搜索")
        })
        .navigationBarItems(trailing: Button(action: {
            let ss = dds.allBinds.map { bd in
                return "\(bd.endTime - bd.startTime)"
            }.joined(separator: ",")
            print("连接时间:\(ss)")
        }, label: {
            Text("输出时间")
        }))
        
    }
}

#Preview {
    NavigationView {
        ContentView()
    }
}
