//
//  EcgNotify.swift
//  yasee_ios_demo
//
//  Created by Henry Gao on 2024/9/14.
//

import Foundation
import yasee_ios


class EcgNotify: ObservableObject {
    @Published 
    var ecgData: [Double] = []
    
    /// 原始的数据
    var rawData: [Double] = []
    
    /// 没有绘制在屏幕上的点
    var unShows: [Double] = []
    
    init() {
        /// 获取原始数据
        let ecgCall: NotifyCall<NotifyDeviceData> = { data in
            guard
                let value = String(data: data.data.data, encoding: .utf8)
            else { return }
            let vv = value.components(separatedBy: ",").map { Double($0 as String) ?? 0 }
            self.unShows.append(contentsOf: vv)
            self.rawData.append(contentsOf: vv)
        }
        Notify.single.listen(ecgCall)
        
        /// 刷新数据
        var _index = 0;
        Timer.scheduledTimer(withTimeInterval: 0.003, repeats: true) { _ in
            if self.unShows.count == 0 { return }
            if _index == 500 { _index = 0 }
            
            if self.ecgData.count >= 500 {
                self.ecgData.replaceSubrange(_index..<_index+1, with: [self.unShows.remove(at: 0)])
            } else {
                self.ecgData.append(self.unShows.remove(at: 0))
            }
            _index += 1
        }
    }
}
